<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="tableStyle.css?v=<?php echo time(); ?>">
    <script src="https://cdn.jsdelivr.net/npm/xlsx@0.18.5/dist/xlsx.full.min.js"></script>
    <title>SELL</title>
    <style>
        .main {
            width: 100%;
            display: flex;
            flex-direction: row;
            margin: 0px;
        }

        .divleft {
            width: 10%;
            display: flex;
            flex-direction: column;
        }

        .divright {
            width: 85%;
            height: 90vh;
            background-color: rgb(255, 247, 227);
            padding: 20px;
        }

        .divleft button {
            width: 80%;
            height: 50px;
            margin-bottom: 20px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
        }

        .divleft button:hover {
            background-color: #b3cce6;
        }

        .divright button {
            margin: 10px 10px 10px 0px;
            padding: 8px 14px;
            background-color: #3399ff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        #searchInput,
        #SupplInput,
        #resetBtn,
        #searchidapranq,
        #kod {
            height: 40px;
            font-size: 20px;
        }

        #lastorders .record-navigator {
            display: none;
        }

        #productForm {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
        }

        .accordion {
            cursor: pointer;
            display: flex;
            justify-content: left;
            align-items: center;
        }

        .accordion:hover {
            background-color: #ddd;
            border-radius: 10px;
        }

        .accordion .chevron {
            transition: transform 0.3s;
        }

        .accordion.active .chevron {
            transform: rotate(90deg);
        }

        .panel {
            width: 100%;
            background-color: transparent;
            display: none;
            overflow: hidden;
            border-radius: 5px;
            font-size: 14px;
            color: #333;
        }

        .panel button {
            width: 100%;
            background-color: transparent;
            margin: 0px;
            text-align: start;
        }
    </style>
</head>

<body>
    <div class="main">
        <div class="divleft">
            <button type="submit" onclick="OpenMyPage(1)">Ապրանքներ</button>
            <button type="submit" onclick="OpenMyPage(2)">Մուտք</button>
            <button type="submit" onclick="OpenMyPage(3)">Վաճառք</button>
            <button type="submit" onclick="suppl()">Մատակարարներ</button>
            <button type="submit" onclick="OpenMyPage(5)">Տեղեկատուներ</button>
            <button type="submit" onclick="" class="accordion">Հաշվետվություններ</button>
            <div class="panel">
                <button type="submit" onclick="fetchVajarqData('divright')"> &#9654; Օրվա ամփոփ</button>
                <button onclick="OpenMyPage(6)">&#9654; Դրամարկղ</button>
                <button>&#9654; Ծախսեր</button>
                <button>&#9654; Ֆինանսկան</button>
            </div>
        </div>
        <div id="divright" class="divright">

        </div>
    </div>

    <script src="tableclass.js"></script>
    <script>
        function suppl() {
            document.getElementById("apranq").hidden = true;
            document.getElementById("order").hidden = true;
            document.getElementById("elq").hidden = true;
            document.getElementById("suppl").hidden = false;

            const contdiv = document.getElementById("tblsuppl");
            contdiv.innerHTML = '';

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    const result = JSON.parse(xhttp.responseText);

                    // ստեղծում է աղյուսակը
                    const newtable = new Table(
                        "#tblsuppl",
                        ["text", "text", "number", "number", "number", "number", "number", "checkbox", "text", "number"],
                        [{
                            idsupplier: "ԻԴՄ"
                        }, {
                            supplier: "Մատակարար"
                        }, {
                            partq0: "Սկզբնական պարտք"
                        }],
                        result
                    );

                }
            };

            xhttp.open("GET", "suppl_data.php?", true);
            xhttp.send();
        }
    </script>
</body>

</html>

<script>
    /*    async function OpenMyPage(PunktNumber) {
        let div = document.getElementById("divright");
        let url = '';
        let scriptUrl = '';
        let shouldCallGetData = false;

        switch (PunktNumber) {
            case 1:
                url = 'apranqner/index.html';
                scriptUrl = 'apranqner/script.js';
                shouldCallGetData = true;
                break;
            case 2:
                url = 'mutq/index.html';
                scriptUrl = 'mutq/script.js';
                shouldCallGetData = true;
                break;
             case 3:
                url = 'vajarq/index.html';
                scriptUrl = 'vajarq/script.js';
                shouldCallGetData = true;
                break;
            
            case 5:
                url = 'texekatuner/index.html';
                scriptUrl = 'texekatuner/texekatuner.js';
                shouldCallGetData = true;
                break;
            case 6:
                url = 'dramarkx/index.html';
                scriptUrl = 'dramarkx/script.js';
                shouldCallGetData = true;
                break;
            default:
                return;
        }

        const html = await fetch(url).then(res => res.text());
        div.innerHTML = html;

        // 3. Проверяем, подключён ли скрипт
        const isLoaded = Array.from(document.scripts).some(s => s.src.includes(scriptUrl));

        if (!isLoaded) {
            // 4. Загружаем скрипт вручную и ждем
            await loadScript(scriptUrl);
        } else {
            if (scriptUrl == 'apranqner/script.js') { get_apranq_data(); }
            if (scriptUrl == 'mutq/script.js') { get_lastorder(); }
            //if (scriptUrl == 'mutq/script.js') { get_orderapranq(); }
        }
    }
    // Вспомогательная функция загрузки внешнего JS
    function loadScript(src) {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = src + '?v=' + Date.now(); // cache-busting
            script.onload = resolve;
            script.onerror = () => reject(new Error(`error ${src}`));
            document.body.appendChild(script);
        });
    }
*/

    async function OpenMyPage(PunktNumber) {
        let div = document.getElementById("divright");
        let url = '';
        let scriptUrl = '';
        let shouldCallGetData = false;

        switch (PunktNumber) {
            case 1:
                url = 'apranqner/index.html';
                scriptUrl = 'apranqner/script.js';
                shouldCallGetData = true;
                break;
            case 2:
                url = 'mutq/index.html';
                scriptUrl = 'mutq/script.js';
                shouldCallGetData = true;
                break;
            case 3:
                url = 'vajarq/index.html';
                scriptUrl = 'vajarq/script.js';
                shouldCallGetData = true;
                break;
            case 5:
                url = 'texekatuner/index.html';
                scriptUrl = 'texekatuner/texekatuner.js';
                shouldCallGetData = true;
                break;
            case 6:
                url = 'dramarkx/index.html';
                scriptUrl = 'dramarkx/script.js';
                shouldCallGetData = true;
                break;
            default:
                return;
        }

        // Загружаем HTML-страницу
        const html = await fetch(url).then(res => res.text());
        div.innerHTML = html;

        // Загружаем и выполняем скрипт
        const isLoaded = Array.from(document.scripts).some(s => s.src.includes(scriptUrl));

        if (!isLoaded) {
            // Если скрипт ещё не загружен, загружаем его
            await loadScript(scriptUrl);
        }

        // Если необходимо, вызываем нужные функции после загрузки скрипта
        if (shouldCallGetData) {
            if (scriptUrl == 'apranqner/script.js') {
                get_apranq_data();
            }
            if (scriptUrl == 'mutq/script.js') {
                get_lastorder();
            }
            if (scriptUrl == 'vajarq/script.js') {
                get_orderapranq();
            }
            if (scriptUrl == 'dramarkx/script.js') {
                get_exp(1);
            }
        }
    }

    // Вспомогательная функция для загрузки внешнего JS
    function loadScript(src) {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = src + '?v=' + Date.now(); // cache-busting (добавление уникального параметра для предотвращения кеширования)
            script.onload = resolve;
            script.onerror = () => reject(new Error(`Ошибка при загрузке скрипта: ${src}`));
            document.body.appendChild(script);
        });
    }


    //--------------Հաշվետվություններ -> Օրվա ամփոփ վաճառք  ----------------------------------
    function fetchVajarqData(contdiv, param) {
        // Using fetch API to replace XMLHttpRequest
        const container = document.getElementById(contdiv);
        //container.innerHTML = '';
        let dataValue = "";

        if (param == 2) {
            dataValue = document.getElementById("date").value;
            //console.log(dataValue);
            document.getElementById("ktron").innerHTML = '';
        } else {
            if (contdiv === "divright") {
                container.innerHTML = '';
            }
            const dateInput = document.createElement('input');
            dateInput.type = 'date';
            dateInput.id = 'date';
            dateInput.name = 'date';

            dateInput.addEventListener('change', function() {
                fetchVajarqData("divright", 2);
            });

            // ընթացիկ ամսաթիվը
            const currentDate = new Date();
            const yyyy = currentDate.getFullYear();
            const mm = String(currentDate.getMonth() + 1).padStart(2, '0'); // Месяцы начинаются с 0
            const dd = String(currentDate.getDate()).padStart(2, '0');
            dateInput.value = `${yyyy}-${mm}-${dd}`;
            dataValue = `${yyyy}-${mm}-${dd}`;

            container.appendChild(dateInput);

            const ktronDiv = document.createElement("div");
            ktronDiv.id = "ktron";
            container.appendChild(ktronDiv);
        }

        fetch("get_vajarq.php?dataValue=" + dataValue)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(result => {
                if (result === "0") {
                    alert("Այսօր դեռ վաճառք չկա");
                    return;
                }

                // Create the table
                const newTable = new Table(
                    "#ktron",
                    [false, false, true, false, false],
                    ['', '', '', ''],
                    ["number", "text", "number", "number"],
                    [{
                        idvajarq: "Կտրոն N:"
                    }, {
                        amst: "Ժամ"
                    }, {
                        gumar: "Գումար"
                    }, {
                        money: "Վճար"
                    }],
                    result
                );

                // Mark the first row
                const firstRow = document.querySelector('#' + `${contdiv}` + ' tbody tr');
                if (firstRow) {
                    const c = firstRow.querySelectorAll('td');
                    //document.getElementById('idktron').value = c
                    if (document.getElementById('idktron')) {
                        document.getElementById('idktron').value = c[1].textContent.trim()
                    } else {
                        const newInput = document.createElement("input");
                        newInput.id = "idktron";
                        newInput.value = c[1].textContent.trim();
                        container.appendChild(newInput);
                    }
                    const newDiv = document.createElement("div");
                    newDiv.id = "ktron_data";


                    container.appendChild(newDiv);
                }
                if (contdiv === "history_vajarq_sub") {
                    document.getElementById('history_vajarq').style.display = 'block';
                }
                chose_ktron(contdiv);
            })
            .catch(error => {
                console.error('There was a problem with the fetch operation:', error);
            });

    }

    function chose_ktron(contdiv) {
        const idv = document.getElementById('idktron').value;

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                const result = JSON.parse(xhttp.responseText);
                if (result == "0") {
                    alert("Այսօր դեռ վաճառք չկա");
                    return;
                }
                const newtable = new Table(
                    "#ktron_data",
                    [false, false, false, false, false, false],
                    ['', '', '', '', '', ''],
                    ["number", "text", "number", "number", "number", "number"],
                    [{
                        idapranq: "IDApranq"
                    }, {
                        apranq: "Apranq"
                    }, {
                        qan: "Քանակ"
                    }, {
                        p2: "Գին"
                    }, {
                        z: "Զեղչ"
                    }, {
                        p1: "Գին"
                    }],
                    result
                );
            }
        }
        xhttp.open("GET", "get_vajarq.php?idvajarq=" + idv, true);
        xhttp.send();
    }

    // սլաքներով օրվա ամփոփի մեջ շարժվել վերև ներքև
    /*let rows = [];
    let active = null;

    if (document.getElementById('history_vajarq').style.display === 'block') {
        rows = Array.from(document.querySelectorAll('#ktron tbody tr'));
        active = document.querySelector('#ktron tbody .active-row');
    } 

    if (event.key === 'ArrowUp') {
            if (currentIndex > 0) {
                active.classList.remove('active-row');
                rows[currentIndex - 1].classList.add('active-row');
                if (document.getElementById('history_vajarq').style.display === 'block') {
                    const kt = document.querySelector('#ktron tbody .active-row');
                    const c = kt.querySelectorAll('td');
                    document.getElementById('idktron').value = c[1].textContent.trim();
                    chose_ktron();
                }
            }
    } else if (event.key === 'ArrowDown') {
            if (currentIndex < rows.length - 1) {
                active.classList.remove('active-row');
                rows[currentIndex + 1].classList.add('active-row');
                if (document.getElementById('history_vajarq').style.display === 'block') {
                    const kt = document.querySelector('#ktron tbody .active-row');
                    const c = kt.querySelectorAll('td');
                    document.getElementById('idktron').value = c[1].textContent.trim();
                    chose_ktron();
                }
            }
    }*/
    document.addEventListener('keydown', function(event) {
        let rows = [];
        let active = null;

        /*    if (document.getElementById('ktron_data')) {  // Check if the div with id="ktron_data" exists
                rows = Array.from(document.querySelectorAll('#ktron tbody tr'));
                active = document.querySelector('#ktron tbody .active-row');
            } */
        if (document.getElementById("findapr2")) {
            rows = Array.from(document.querySelectorAll('#findapr_data2 tbody tr'));
            active = document.querySelector('#findapr_data2 tbody .active-row');
        } else if (document.getElementById('ktron')) {
            rows = Array.from(document.querySelectorAll('#ktron tbody tr'));
            active = document.querySelector('#ktron tbody .active-row');
        } else if (document.getElementById('vajarq')) {
            rows = Array.from(document.querySelectorAll('#vajarq tbody tr'));
            active = document.querySelector('#vajarq tbody .active-row');
        }

        const currentIndex = rows.indexOf(active);
        if (event.key === 'ArrowUp') {
            if (currentIndex > 0) {
                active.classList.remove('active-row');
                rows[currentIndex - 1].classList.add('active-row');
                if (document.getElementById('ktron_data')) { // Check if div with id="ktron_data" exists
                    const kt = document.querySelector('#ktron tbody .active-row');
                    const c = kt.querySelectorAll('td');
                    document.getElementById('idktron').value = c[1].textContent.trim();
                    chose_ktron();
                }
            }
        } else if (event.key === 'ArrowDown') {
            if (currentIndex < rows.length - 1) {
                active.classList.remove('active-row');
                rows[currentIndex + 1].classList.add('active-row');
                if (document.getElementById('ktron_data')) { // Check if div with id="ktron_data" exists
                    const kt = document.querySelector('#ktron tbody .active-row');
                    const c = kt.querySelectorAll('td');
                    document.getElementById('idktron').value = c[1].textContent.trim();
                    chose_ktron();
                }
            }
        }
    });

    //-----------------Տպել-------------------------------------------------------------
    function printDiv(pdiv) {
        var printContents = document.getElementById(pdiv).innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }

    //-----------------կախովի մենյու   -------------------------------------------------  
    function initAccordions(selector, closeOthers = true) {
        const acc = document.querySelectorAll(selector);

        acc.forEach(btn => {
            btn.addEventListener("click", function() {
                this.classList.toggle("active");
                const panel = this.nextElementSibling;

                // pakum e mnacac
                if (closeOthers) {
                    acc.forEach(other => {
                        if (other !== this) {
                            other.classList.remove("active");
                            if (other.nextElementSibling) {
                                other.nextElementSibling.style.display = "none";
                            }
                        }
                    });
                }

                if (panel) {
                    panel.style.display = (panel.style.display === "block") ? "none" : "block";
                }
            });
        });
    }
    initAccordions(".accordion", true);
</script>