// ստանում ենք ընթացիկ ժամանակը
const timestamp = new Date().getTime();
const style = document.getElementById('dynamic-styles');
// ժամանակի ցուցիչը ավելացնում ենք որպես քոմենթ, որպեսզի փոփոխության         դեպքում թարմացնենք սթայլը 
style.innerHTML += ` /* Updated at: ${timestamp} */ `;

function get_lastorder() {
    const contdiv = document.getElementById("lastorders");
    const limit = document.getElementById("limit").value;
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը-----    
            const newtable = new Table(
                "#lastorders",
                [false, false, false, false],
                ['', 'none', '', ''],
                ["number", "number", "text", "data"],
                [{ idorder: "Մուտք N:" }, { idsupplier: "idՄատ" }, { supplier: "Մատակարար" }, { amst: "ԱՄՍԹ" }],
                result
            );
        }
    };

    xhttp.open("GET", "lastorder_data.php?limit=" + limit, true);
    xhttp.send();
}

function suppl_data() {

    const contdiv = document.getElementById("suppl_data");
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#suppl_data",
                [false, false],
                ['', ''],
                ["number", "text"],
                [{ idsupplier: "Կոդ" }, { supplier: "Մատակարար" }],
                result
            );

            const table = document.querySelector("#suppl_data table");
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

            const supplSet = new Set();
            const datalist = document.getElementById('select_suppllist');
            datalist.innerHTML = '';
            for (let row of rows) {
                const supplier1 = row.cells[2].textContent.trim();

                if (!supplSet.has(supplier1)) {
                    supplSet.add(supplier1);
                    const opt = document.createElement('option');
                    opt.value = supplier1;
                    datalist.appendChild(opt);
                }
            }
        }
    };

    xhttp.open("GET", "suppl_data.php?", true);
    xhttp.send();
}
function order_apranq() {
    const contdiv = document.getElementById("orderapranq");
    const container = document.getElementById("lastorders");
    contdiv.innerHTML = '';

    //const activrows = container.querySelectorAll('tbody tr');
    // const activeRows = document.getElementsByClassName('active-row');
    const activeRows = document.querySelectorAll('#lastorders .active-row');  //վերցնում է հենց lastorders-ի աղյուսակի նշված տողերը

    if (activeRows.length == 1) {
        const cells = activeRows[0].getElementsByTagName('td');
        const ido = cells[1].textContent.trim();
        const idsuppl = cells[2].textContent.trim();
        const suppl = cells[3].textContent.trim();
        const amst = cells[4].textContent.trim();
        document.getElementById("ido").value = ido;
        document.getElementById("idsuppl").value = idsuppl;
        document.getElementById("amst").value = amst;
        document.getElementById("suppl").value = suppl;
        get_orderapranq(ido);
        document.getElementById("idapranq").focus();
        // Remove active-row class from all rows
        for (let row of activeRows) {
            row.classList.remove('active-row');
        }
    } else {
        alert("Ընտրեք միայն մեկ մուտք");
    }
}

function get_orderapranq(ido) {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#orderapranq",
                [false, false, false, false, true, false, false, false, false, false, false, false, false],
                ['none', 'none', 'none', '', '', '', '', '', '', '', '', '', ''],
                ["number", "number", "number", "text", "text", "number", "number", "number", "number", "number", "number", "text"],
                [{ id: "ԻԴ" }, { idorder: "ԻԴO" }, { ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { qan: "Քանակ" }, { p0office: "Առք" }, { zexj: "Զեղչ" }, { p0: "Առք" }, { total: "Ընդամենը" },  { p1: "Գին" }, { vradir: "վրադիր" }, { atg: "ԱՏԳ" }],
                result
            );
            get_total();
        }
    };

    xhttp.open("GET", "order_apranq.php?ido=" + ido, true);
    xhttp.send();
}
function suppFilter() {
    const inputSuppl = document.getElementById('select_suppl');
    const table = document.querySelector("#suppl_data table");
    const rows = table?.getElementsByTagName('tbody')[0]?.getElementsByTagName('tr') || [];

    const supplText = inputSuppl.value.toLowerCase().trim();
  
    for (let row of rows) {
        const suppl = row.cells[2].textContent.trim().toLowerCase();
        const matchSuppllist = !supplText || suppl === supplText;

        row.style.display = (matchSuppllist) ? '' : 'none';
    }
}
function filter_suppl() {
    const inputSuppl = document.getElementById('select_suppl');
    const table = document.querySelector("#suppl_data table");
    const rows = table?.getElementsByTagName('tbody')[0]?.getElementsByTagName('tr') || [];
    const supplText = inputSuppl.value.toLowerCase().trim();

    let scrolled = false;
    for (let row of rows) {
        const suppl = row.cells[2].textContent.trim().toLowerCase();

        if (supplText && suppl === supplText) {
            row.classList.add('active-row');

            if (!scrolled) {
                row.scrollIntoView({ behavior: 'smooth', block: 'center' });
                scrolled = true;
            }
        } else {
            row.classList.remove('active-row');
        }
    }
}
function new_order() {
    //const row = document.getElementsByClassName('active-row');
    const row = document.querySelectorAll('#suppl_data .active-row');
    if (row.length == 1) {
        const cells = row[0].getElementsByTagName('td');
        const ids = cells[1].textContent.trim();

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                //const result = JSON.parse(xhttp.responseText);
                get_lastorder();
                row[0].classList.remove('active-row');
                alert(xhttp.responseText);
            }
        }
        xhttp.open("GET", "new_order.php?idsupplier=" + ids, true);
        xhttp.send();
    } else {
        alert("Ընտրեք միայն մեկ մատակարար");
    }
}
function find_apranq(ind) {
    if (ind == 1) {
        const ida = document.getElementById("ida");
        const kod = document.getElementById("idapranq").value;
        const apr = document.getElementById("apranq");
        const us = document.getElementById("us");
        const scale = document.getElementById("scale");
        const p0office = document.getElementById("p0office");
        const zexj = document.getElementById("zexj");
        const p0 = document.getElementById("p0");
        const p1 = document.getElementById("p1");
        const atg = document.getElementById("atg");

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const result = JSON.parse(xhttp.responseText);
                console.log(result)
                if (result.length == 0) {
                    alert("այդպիսի կոդով ապրանք չկա բազայում");
                } else {
                    ida.value = result[0].ida;
                    apr.value = result[0].apranq;
                    us.value = result[0].us;
                    scale.value = result[0].scale;
                    p0office.value = result[0].p0office;
                    zexj.value = result[0].zexj;
                    p0.value = result[0].p0;
                    p1.value = result[0].p1;
                    atg.value = result[0].atg;

                    document.getElementById("qan").focus();
                }
            }
        }
        xhttp.open("GET", "get_order_apranq.php?idapranq=" + kod, true);
        xhttp.send();
    } else {
        const kod = document.getElementById("idapranq").value;
        if (kod == "") {

            document.getElementById('findapr').style.display = 'block';
            const apr = document.getElementById("apranq").value;

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const result = JSON.parse(xhttp.responseText);
                    const contdiv = document.getElementById("findapr_data");
                    contdiv.innerHTML = '';
                    const newtable = new Table(
                        "#findapr_data",
                        [false, false, true, false, false, false, false, false, false],
                        ['', '', '', '', '', '', '', '', ''],
                        ["number", "text", "text", "number", "number", "number", "number", "number"],
                        [{ ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { qan: "Քանակ" }, { p0office: "Առք" }, { zexj: "Զեղչ" }, { p0: "Առք" }, { p1: "Գին" }, { vradir: "Վրադիր" }],
                        result
                    );

                }
            }
            xhttp.open("GET", "get_order_apranq.php?apranq=" + apr, true);
            xhttp.send();
        }
    }
}
function add_new_apr() {
    const ida = document.getElementById("ida").value;
    const idapranq = document.getElementById("idapranq").value;
    const apranq = document.getElementById("apranq").value;
    const qan = document.getElementById("qan").value;
    const p0office = document.getElementById("p0office").value;
    const zexj = document.getElementById("zexj").value;
    const p0 = document.getElementById("p0").value;
    const p1 = document.getElementById("p1").value;

    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            console.log(result);
            document.getElementById("ida").value = result;
        }
    }
    xhttp.open("GET", "new_apr.php?ida=" + ida + "&idapranq=" + idapranq + "&apranq=" + apranq + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1, true);
    xhttp.send();
}
function orderapranq_newrow() {
    // if (validateAll()) {

    var ida = document.getElementById("ida").value;
    const idapranq = document.getElementById("idapranq").value;
    const apranq = document.getElementById("apranq").value;
    const us = document.getElementById("us").value;
    const scale = document.getElementById("scale").value;
    const qan = document.getElementById("qan").value;
    const p0office = document.getElementById("p0office").value;
    const zexj = document.getElementById("zexj").value;
    const p0 = document.getElementById("p0").value;
    const p1 = document.getElementById("p1").value;
    const ido = document.getElementById("ido").value;
    const idsuppl = document.getElementById("idsuppl").value;
    const atg = document.getElementById("atg").value;
    const total = document.getElementById("total").value;
    //add_new_apr();
    const vradir = ((parseFloat(p1) - parseFloat(p0)) / parseFloat(p0)).toFixed(2);

    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            if (result != "") {
                document.getElementById("ida").value = result;
                console.log(result);
                ida = result;
            }

            var xhttp2 = new XMLHttpRequest();
            xhttp2.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    if (xhttp2.responseText == 0) {
                        "Չի հաջողվել ավելացնել";
                    } else {
                        //update_qan(ida, qan); 
                        const id = xhttp2.responseText;
                        const table = document.querySelector('#orderapranq tbody');
                        const tr = document.createElement('tr');


                        const count_rows = document.querySelector('#orderapranq .count_rows').innerHTML;
                        const count_tr = Number(count_rows.slice(2)) + 1;

                        const td1 = document.createElement('td');
                        const bt = document.createElement('input');
                        bt.type = "button";
                        bt.value = count_tr;
                        bt.addEventListener('click', (event) => checkRow(event));
                        td1.appendChild(bt);
                        tr.appendChild(td1);

                        const td2 = document.createElement('td');
                        td2.textContent = id;
                        td2.hidden = true;
                        tr.appendChild(td2);

                        const tr_data = [idapranq, apranq, qan, p0office, zexj, p0, total, p1, vradir, atg]
                        tr_data.forEach((value, index, array) => {
                            const td = document.createElement('td');
                            td.textContent = value;
                            tr.appendChild(td);
                        });
                        table.appendChild(tr);
                        let scrolled = false;
                        if (!scrolled) {
                            tr.scrollIntoView({ behavior: 'smooth', block: 'center' });
                            scrolled = true;
                        };


                        document.getElementById("ida").value = "";
                        document.getElementById("idapranq").value = "";
                        document.getElementById("apranq").value = "";
                        document.getElementById("qan").value = "";
                        document.getElementById("p0office").value = "";
                        document.getElementById("zexj").value = "";
                        document.getElementById("p0").value = "";
                        document.getElementById("p1").value = "";
                        document.getElementById("atg").value = "";
                        document.getElementById("total").value = "";

                        //total
                        const s_p0 = qan * p0;
                        const s_p1 = qan * p1;
                        const sumP0Input = document.getElementById("sumP0");
                        const sumP1Input = document.getElementById("sumP1");

                        // փեխակերպում ենք թվի
                        const currentSumP0 = parseFloat(sumP0Input.value) || 0;
                        const currentSumP1 = parseFloat(sumP1Input.value) || 0;

                        sumP0Input.value = (currentSumP0 + s_p0).toFixed(2);
                        sumP1Input.value = (currentSumP1 + s_p1).toFixed(2);
                        //get_total();

                        document.getElementById('idapranq').focus()
                    }
                }
            }
            xhttp2.open("GET", "order_apranq_addrow.php?ido=" + ido + "&ida=" + ida + "&apranq=" + apranq + "&qan=" + qan + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1 + "&vradir=" + vradir, true);
            xhttp2.send();

        }
    }
    xhttp.open("GET", "new_apr.php?ida=" + ida + "&idapranq=" + idapranq + "&apranq=" + apranq + "&us=" + us + "&scale=" + scale + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1 + "&idsuppl=" + idsuppl + "&atg=" + atg, true);
    xhttp.send();
    //    }

}
function find_apr() {
    //const row = document.getElementsByClassName('active-row');
    const row = document.querySelectorAll('#findapr_data .active-row');  //վերցնում է հենց findapr_data-ի աղյուսակի նշված տողերը
    if (row.length == 1) {
        const cells = row[0].getElementsByTagName('td');
        const ida = cells[1].textContent.trim();

        document.getElementById("ida").value = cells[1].textContent.trim();;
        document.getElementById("idapranq").value = cells[2].textContent.trim();;
        document.getElementById("apranq").value = cells[3].textContent.trim();;
        document.getElementById("qan").value = cells[4].textContent.trim();;
        document.getElementById("p0office").value = cells[5].textContent.trim();;
        document.getElementById("zexj").value = cells[6].textContent.trim();;
        document.getElementById("p0").value = cells[7].textContent.trim();;
        document.getElementById("p1").value = cells[8].textContent.trim();;
        row[0].classList.remove('active-row');
    } else {
        alert("Ընտրեք միայն մեկ ապրանք");
    }
}
function delete_rows() {
    //const rows = document.getElementsByClassName('active-row');
    const rows = document.querySelectorAll('#orderapranq .active-row');  //վերցնում է հենց orderapranq-ի աղյուսակի նշված տողերը
    if (rows.length > 0) {
        const data = [];
        for (let i = 0; i < rows.length; i++) {
            let cells = rows[i].getElementsByTagName('td');
            let id = cells[1].textContent.trim();
            data.push(Number(id));

            /*    let ida = Number(cells[3].textContent.trim());
                let qanTarb=Number("-" + cells[6].textContent.trim());
            
                console.log(ida);
                update_qan(ida, qanTarb);*/
        }

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const contdiv = document.getElementById("orderapranq");
                contdiv.innerHTML = '';
                const ido = document.getElementById("ido").value;
                get_orderapranq(ido);
                alert(xhttp.responseText);
                get_total();
            }
        }
        xhttp.open("GET", "delete_orderapranq.php?data=" + data, true);
        xhttp.send();

    } else {
        alert("Ընտրեք առնվազն մեկ տող");
    }
}
function new_apr() {
    const idapranq = document.getElementById("idapranq").value;
    //const apranq = document.getElementById("new_apranq").value;
    const idsuppl = document.getElementById("idsuppl").value;

    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;

            //            if(Number.isFinite(result)){
            document.getElementById("ida").value = result;
            console.log(result);
            //            }
            document.getElementById("idapranq").value = idapranq;
            //document.getElementById("apranq").value = apranq;
        }
    }

    xhttp.open("GET", "new_apr.php?idapranq=" + idapranq + "&idsuppl=" + idsuppl, true);
    xhttp.send();

}
function checkRow(event) {
    const button = event.currentTarget;
    const rowElement = button.closest('tr');

    //նշել ընթացիկ տողը
    if (rowElement) {
        if (rowElement.classList.contains('active-row')) {
            rowElement.classList.remove('active-row');
        } else {
            rowElement.classList.add('active-row');
        }
        //console.log("Clicked row:", rowElement);
    }
}


// Չենք օգտագործում, մնացորդի կարգավորումը տրիգերներով
function update_apranq_info(ida, apranq, p0office, zexj, p0, p1) {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            console.log(result);

        }
    }
    xhttp.open("GET", "update_apranq_info.php?ida=" + ida + "&apranq=" + apranq + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1, true);
    xhttp.send();
}

function get_total() {
    //    const table = document.getElementById("orderapranq");
    //    const rows = table.querySelectorAll("tbody tr");

    let total_arq = 0;
    let total_vaj = 0;

    const rows = document.querySelectorAll('#orderapranq tbody tr');
    console.log(rows);
    if (rows.length > 0) {
        for (let i = 0; i < rows.length; i++) {
            const cells = rows[i].getElementsByTagName('td');

            const count = parseFloat(cells[6].textContent.trim());
            const p0 = parseFloat(cells[9].textContent.trim());
            const p1 = parseFloat(cells[10].textContent.trim());

            total_arq += count * p0;
            total_vaj += count * p1;
        }
    }
    document.getElementById("sumP0").value = (total_arq).toFixed(2);
    document.getElementById("sumP1").value = (total_vaj).toFixed(2);
}
function get_new_code() {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            //console.log(result); 
            document.getElementById("idapranq").value = result;
            new_apr();
            document.getElementById('apranq').focus()
            //find_apranq(1);
        }
    }
    xhttp.open("GET", "get_new_code.php?", true);
    xhttp.send();
}
function calcZexj() {
    const p0 = document.getElementById('p0');
    const p0office = document.getElementById('p0office').value;
    const zexj = document.getElementById('zexj').value;

    p0.value = (p0office * (1 - zexj / 100)).toFixed(2);
    document.getElementById('total').value=(document.getElementById('qan').value* p0.value).toFixed(2);
}


//-----------տեքստային տվյալների  մուտքի համար 
function validateProductName(name) {
    // տառեր, բացատ, "-",  "․", ","
    const regex = /^[a-zA-Zа-яА-ЯёЁ\s\-\u0531-\u058F\.,]+$/; // կետը՝ \.
    if (name.trim() === '') {
        alert('Դաշտը չի կարող դատարկ լինել');
    }
    if (!regex.test(name)) {
        alert('Տեքստային դաշտը կարող է պարունակել միայն տառեր, բացատ, "-", ","  և "․"');
    }
    return 'OK';
}

/* function printDiv(){
        var printContents = document.getElementById("printableArea").innerHTML;
        var originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
    }
*/

//------------- testing mutq-----------------
//const form = document.getElementById('productForm');-----------------

const barcodeInput = document.getElementById('idapranq');
const nameInput = document.getElementById('apranq');
const quantityInput = document.getElementById('qan');
const price0OfficeInput = document.getElementById('p0office');
const zexjInput = document.getElementById('zexj');
const price0Input = document.getElementById('p0');
const priceInput = document.getElementById('p1');

function validateBarcode() {
    const value = barcodeInput.value.trim();
    const numericRegex = /^\d+$/;

    if (value.length < 4 || value.length > 15) {
        alert("Շտրիխ կոդը պետք է լինի 4-ից 13 նիշ երկարությամբ։");
        return false;
    }
    if (!numericRegex.test(value)) {
        alert("Շտրիխ կոդը պետք է պարունակի միայն թվեր։");
        return false;
    }
    return true;
}

function validateName() {
    const value = nameInput.value.trim();
    const regex = /^[a-zA-Zа-яА-ЯёЁ\s\-\u0531-\u058F\.,]+$/; // կետը՝ \.
    if (value === "") {
        alert("Անվանումը պարտադիր է։");
        return false;
    }
    if (value.length > 50) {
        alert("Անվանումը չպետք է գերազանցի 70 նիշ։");
        return false;
    }
    if (!regex.test(value)) {
        alert('Տեքստային դաշտը կարող է պարունակել միայն տառեր, բացատ, "-", ","  և "․"');
    }
    return true;
}

function validateQuantity() {
    const value = quantityInput.value.trim();
    if (value === "") {
        alert("Քանակը պարտադիր է։");
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        alert("Քանակը պետք է լինի թիվ։");
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 4 || (decPart && decPart.length > 3)) {
        alert("Քանակը պետք է լինի առավելագույնը 4 նիշ ամբողջ մասում և 3 նիշ տասնորդականում։");
        return false;
    }
    return true;
}

function validatePrice() {
    const value = priceInput.value.trim();
    if (value === "") {
        alert("Գինը պարտադիր է։");
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        alert("Գինը պետք է լինի թիվ։");
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 8 || (decPart && decPart.length > 2)) {
        alert("Գինը պետք է լինի առավելագույնը 8 նիշ ամբողջ մասում և 2 նիշ տասնորդականում։");
        return false;
    }
    return true;
}
function validateZexj() {
    const value = zexjInput.value.trim();
    const num = Number(value);
    if (isNaN(num)) {
        alert("Զեղչը պետք է լինի թիվ։");
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 4 || (decPart && decPart.length > 3)) {
        alert("Զեղչը պետք է լինի 0-100 միջակայքում");
        return false;
    }
    return true;
}

function validatePrice0() {
    const value = price0Input.value.trim();
    if (value === "") {
        alert("Գինը պարտադիր է։");
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        alert("Գինը պետք է լինի թիվ։");
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 8 || (decPart && decPart.length > 2)) {
        alert("Գինը պետք է լինի առավելագույնը 8 նիշ ամբողջ մասում և 2 նիշ տասնորդականում։");
        return false;
    }
    return true;
}

function validateAll() {
    const isValidBarcode = validateBarcode();
    const isValidName = validateName();
    const isValidQuantity = validateQuantity();
    const isValidPrice = validatePrice();
    const isValidPrice0 = validatePrice0();

    return isValidBarcode && isValidName && isValidQuantity && isValidPrice && isValidPrice0;
}

barcodeInput.addEventListener('change', () => {
    validateBarcode();
});

nameInput.addEventListener('change', () => {
    validateName();
});

quantityInput.addEventListener('change', () => {
    validateQuantity();
    document.getElementById('total').value=(quantityInput.value*price0Input.value).toFixed(2);
});
zexjInput.addEventListener('change', () => {
    validateZexj();
    document.getElementById('total').value=(quantityInput.value*price0Input.value).toFixed(2);
});

priceInput.addEventListener('change', () => {
    validatePrice();
});
price0Input.addEventListener('change', () => {
    validatePrice0();
    document.getElementById('total').value=(quantityInput.value*price0Input.value).toFixed(2);
});

/*form.addEventListener('submit', function (e) {

    orderapranq_newrow();

});*/
//---------

//---------- enter-ով թռնի inp2 դաշտերով
//document.addEventListener("DOMContentLoaded", function() {
const inputs = document.querySelectorAll(".inp2");
inputs.forEach((input, index) => {
    input.addEventListener("keydown", function (event) {
        if (event.key === "Enter") {
            event.preventDefault();  // Предотвращаем стандартное поведение (например, отправка формы)
            if (inputs[index + 1]) {
                inputs[index + 1].focus();
            } else {
                document.getElementById("save").focus();
            }
        }
    });
});
//});


get_lastorder(); 