class Table {
    constructor(container, types, columns, data = []) {
        this.container = document.querySelector(container);
        this.types = types;
        this.columns = columns.map(col => Object.values(col)[0]);
        this.keys = columns.map(col => Object.keys(col)[0]);
        this.data = data;
        this.render();
    }


    render() {
        this.container.innerHTML = '';
        const tableWrapper = document.createElement('div');
        tableWrapper.classList.add('table-wrapper');

        const table = document.createElement('table');
        table.classList.add('tableStyle');

        const thead = document.createElement('thead');
        const headerRow = document.createElement('tr');

        const th = document.createElement('th');
        th.textContent = "NN";
        th.className = "nn";
        headerRow.appendChild(th);
        this.columns.forEach(col => {
            const th = document.createElement('th');
            th.textContent = col;
            headerRow.appendChild(th);
        });
        thead.appendChild(headerRow);
        table.appendChild(thead);

        const tbody = document.createElement('tbody');
        var i = 0;
        this.data.forEach(row => {
            const tr = document.createElement('tr');

            const td = document.createElement('td');
            const bt = document.createElement('input');
            bt.type = "button";
            bt.className = "nn";

            i = i + 1;
            bt.value = i;
            bt.addEventListener('click', (event) => this.checkRow(event));


            td.appendChild(bt);
            tr.appendChild(td);

            this.keys.forEach((key, colIndex) => {
                const td = document.createElement('td');
                const input = document.createElement('input');
                const type = this.types[colIndex] || 'text';
                input.type = type;
                input.className = key;

                if (type === 'checkbox') {
                    input.checked = row[key] === true || row[key] === "true";
                } else {
                    input.value = row[key] || '';
                }

                td.appendChild(input);
                tr.appendChild(td);
            });




            tbody.appendChild(tr);
        });
        table.appendChild(tbody);

        tableWrapper.appendChild(table);

        const recordNavigator = this.createRecordNavigator();
        tableWrapper.appendChild(recordNavigator);

        // навигационные кнопки внизу таблицы
        const buttonContainer = this.createNavigationButtons();
        tableWrapper.appendChild(buttonContainer);

        this.container.appendChild(tableWrapper);

        this.addKeyboardNavigation();

        if (this.recordInput) this.recordInput.max = this.data.length;
        const ofSpan = this.container.querySelector('.record-total');
        if (ofSpan) ofSpan.textContent = ` of ${this.data.length}`;

    }

    updateData(newData) {
        this.data = newData;
        this.render();
    }

    addRow(row) {
        this.data.push(row);
        this.render();
        this.focusRow(this.data.length - 1);
    }

    addKeyboardNavigation() {
        const inputElements = this.container.querySelectorAll('input');
        const numberOfColumns = this.keys.length;

        inputElements.forEach((input, index) => {
            input.addEventListener('keydown', (e) => {
                if (e.key === "Enter") {
                    e.preventDefault();
                    const nextIndex = (index + 1);
                    if (inputElements[nextIndex]) inputElements[nextIndex].focus();
                } else if (e.key === "ArrowUp") {
                    e.preventDefault();
                    const i = index - (numberOfColumns + 1);
                    if (inputElements[i]) inputElements[i].focus();
                } else if (e.key === "ArrowDown") {
                    e.preventDefault();
                    const i = index + (numberOfColumns + 1);
                    if (inputElements[i]) inputElements[i].focus();
                } else if (e.key === "ArrowRight") {
                    e.preventDefault();
                    if (((index + 1) % (numberOfColumns + 1)) !== 0) {
                        inputElements[index + 1].focus();
                    }
                } else if (e.key === "ArrowLeft") {
                    e.preventDefault();
                    if (((index + 1) % (numberOfColumns + 1)) !== 1) {
                        inputElements[index - 1].focus();
                    }
                }
            });
        });
    }



    createNavigationButtons() {
        const buttonContainer = document.createElement('div');
        buttonContainer.classList.add('table-navigation');

        const addButton = document.createElement('button');
        addButton.textContent = 'Ավելացնել նոր տող';
        addButton.addEventListener('click', () => this.addRow({}));

        const clearButton = document.createElement('button');
        clearButton.textContent = 'Ջնջել աղյուսակը';
        clearButton.addEventListener('click', () => this.updateData([]));

        buttonContainer.appendChild(addButton);
        buttonContainer.appendChild(clearButton);

        return buttonContainer;
    }

    createRecordNavigator() {
        const nav = document.createElement('div');
        nav.classList.add('record-navigator');

        const label = document.createElement('span');
        label.textContent = 'Record:';
        nav.appendChild(label);

        const first = this.createNavButton('⏮', () => this.focusRow(0));
        const prev = this.createNavButton('◀', () => this.focusRow(this.currentRow - 1));
        const next = this.createNavButton('▶', () => this.focusRow(this.currentRow + 1));
        const last = this.createNavButton('⏭', () => this.focusRow(this.data.length - 1));
        const add = this.createNavButton('✳', () => this.addRow({}));

        this.recordInput = document.createElement('input');
        this.recordInput.type = 'number';
        this.recordInput.min = 1;
        this.recordInput.value = 1;
        this.recordInput.addEventListener('change', () => {
            this.focusRow(parseInt(this.recordInput.value, 10) - 1);
        });

        const of = document.createElement('span');
        of.classList.add('record-total');
        of.textContent = ` of ${this.data.length}`;


        nav.appendChild(first);
        nav.appendChild(prev);
        nav.appendChild(this.recordInput);
        nav.appendChild(next);
        nav.appendChild(last);
        nav.appendChild(add);
        nav.appendChild(of);

        this.currentRow = 0;

        return nav;
    }

    createNavButton(text, onClick) {
        const btn = document.createElement('button');
        btn.textContent = text;
        btn.className = 'nav-btn';
        btn.addEventListener('click', onClick);
        return btn;
    }

    focusRow(rowIndex) {
        const tbody = this.container.querySelector('tbody');
        const inputs = tbody.querySelectorAll('input');
        const cols = this.keys.length;

        if (rowIndex >= 0 && rowIndex < this.data.length) {
            const index = rowIndex * cols;
            if (inputs[index]) {
                inputs[index].focus();
                this.currentRow = rowIndex;
                this.recordInput.value = rowIndex + 1;
            }
        }
    }
    checkRow(event) {
        const button = event.currentTarget;
        const rowElement = button.closest('tr');

        // հանել բոլոր նշվածները
        //       const rows = this.container.querySelectorAll('tbody tr');
        //       rows.forEach(r => r.classList.remove('active-row'));


        //նշել ընթացիկ տողը
        if (rowElement) {
            if (rowElement.classList.contains('active-row')) {
                rowElement.classList.remove('active-row');
            } else {
                rowElement.classList.add('active-row');
            }
            console.log("Clicked row:", rowElement);
        }
    }





}
