<?php
$host = 'localhost';
$dbname = 'selldata';
$user = 'root';
$pass = 'mysql';


// Կապ տվյալների բազայի հետ MySQLi-ի միջոցով
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
$conn = new mysqli($host, $user, $pass, $dbname);

// Կապի ստուգում
if ($conn->connect_error) {
    die("կապի սխալ: " . $conn->connect_error);
}

/* ---------------------------------Եթե ֆայլը 'UTF-8' ֆորմատով է-----------------------------------------------------
//SQL-ֆայլի ընթերցում
$sql = file_get_contents('insert_apranq.sql');
if ($sql === false) {
    die("Չի հաջողվել կարդալ SQL-ֆայլը։");
}

// SQL-Հարցման կատարում
if ($conn->multi_query($sql)) {
    echo "SQL-ֆայլի հարցումը հաջողությամբ կատարվել է։\n";
    // Очистка дополнительных результатов (если есть)
    do {
        if ($result = $conn->store_result()) {
            $result->free();
        }
    } while ($conn->more_results() && $conn->next_result());
} else {
    echo "Սխալ SQL-ի կատարման ժամանակ: " . $conn->error;
}

// Փակել կապը 
$conn->close();
----------------------------------------------------------------------------------------------------------------------------------*/


/* ---------------------------------Եթե ֆայլը 'UTF-16LE' ֆորմատով է---------------------------------------------------------------
// Կարդալ SQL ֆայլը որպես հում տվյալներ
$raw = file_get_contents('insert_apranq.sql');
if ($raw === false) {
    die("Չի հաջողվել կարդալ SQL-ֆայլը։");
}

// Կոնվերտացնել UTF-16LE → UTF-8 (եթե файл այս կոդավորմամբ է)
$sql = mb_convert_encoding($raw, 'UTF-8', 'UTF-16LE');

// Հեռացնել BOM, եթե առկա է (UTF-8 BOM = EF BB BF)
if (substr($sql, 0, 3) === "\xEF\xBB\xBF") {
    $sql = substr($sql, 3);
}

// Կատարել SQL հարցումները
if ($conn->multi_query($sql)) {
    echo "SQL-հարցումը հաջողությամբ կատարվեց։\n";
    do {
        if ($result = $conn->store_result()) {
            $result->free();
        }
    } while ($conn->more_results() && $conn->next_result());
} else {
    echo "Սխալ SQL-ի կատարման ժամանակ: " . $conn->error;
}

// Փակել կապը 
$conn->close();
----------------------------------------------------------------------------------------------------------------------------------*/


// Կարդում է ֆայլը
$raw = file_get_contents('insert_apranq.sql');
if ($raw === false) {
    die("Չհաջողվեց կարդալ SQL-ֆայլը։");
}

// ջնջում է BOM (եթե UTF-8-ն  BOM-ով է)
if (substr($raw, 0, 3) === "\xEF\xBB\xBF") {
    $raw = substr($raw, 3);
}

// փորձում է UTF-8-ով
$sql = $raw;
$tryUtf16 = false;

// փորձում է կատարել հարցումը՝ եթե չի ստացվում վերակոդավորում է
try {
    if (!$conn->multi_query($sql)) {
        $tryUtf16 = true;
    }
} catch (mysqli_sql_exception $e) {
    $tryUtf16 = true;
}

// Եթե չի ստացվում փորձում է UTF-16LE → UTF-8
if ($tryUtf16) {
    $sql = mb_convert_encoding($raw, 'UTF-8', 'UTF-16LE');

    // կոնվերտից հետո ջնջում է BOM-ը
    if (substr($sql, 0, 3) === "\xEF\xBB\xBF") {
        $sql = substr($sql, 3);
    }

    // նորից կատարում է հարցումը
    if (!$conn->multi_query($sql)) {
        die("Սխալ SQL-ի կատարման ժամանակ (после перекодировки): " . $conn->error);
    }
}

// Եթե ամեն ինչ ստացվել է, ապա մաքրում է լրացուցիչ արդյունքները
echo "SQL հարցումները հաջողությամբ կատարվեցին։\n";
do {
    if ($result = $conn->store_result()) {
        $result->free();
    }
} while ($conn->more_results() && $conn->next_result());

$conn->close();

?>