class Table {
    constructor(container, editable, hide, types, columns, data = []) {
        this.container = document.querySelector(container);  //կոնտեյների id-ին, որտեղ ստեղծվելու է աղյուսակը
        this.editable = editable;  // փոփխել կարելի է թե ոչ
        this.hide = hide;          // թաքցնել դաշտը` 'none'-այո, ''-ոչ
        this.types = types;      // դաշտերի տիպերը
        this.columns = columns.map(col => Object.values(col)[0]);  // սյունակների հայերեն անվանումները 
        this.keys = columns.map(col => Object.keys(col)[0]);
        this.data = data;
        this.render();
    }

    render() {
        this.container.innerHTML = '';

        const tableWrapper = document.createElement('div');
        tableWrapper.classList.add('table-wrapper');

        const scrollContainer = document.createElement('div');
        scrollContainer.classList.add('table-scroll');

        const table = document.createElement('table');
        table.classList.add('tableStyle');

        const thead = document.createElement('thead');
        const headerRow = document.createElement('tr');

        const thNN = document.createElement('th');
        thNN.textContent = "NN";
        thNN.className = "nn";
        headerRow.appendChild(thNN);

        var j = 0;
        this.columns.forEach(col => {
            const th = document.createElement('th');
            th.textContent = col;
            const hide = this.hide[j];
            th.style.display = hide;
            headerRow.appendChild(th);
            j = j + 1;
        });

        thead.appendChild(headerRow);
        table.appendChild(thead);

        const tbody = document.createElement('tbody');
        if (this.data.length > 0) {
            this.data.forEach((row, index) => {
                const tr = document.createElement('tr');

                /*   const tdIndex = document.createElement('td');
                   tdIndex.textContent = index + 1;
                   tr.appendChild(tdIndex);
               */
                const td = document.createElement('td');
                const bt = document.createElement('input');
                bt.type = "button";
                td.className = "nn";
                bt.value = index + 1;
                bt.addEventListener('click', (event) => this.checkRow(event));
                td.appendChild(bt);
                tr.appendChild(td);

                this.keys.forEach((key, i) => {
                    const td = document.createElement('td');
                    const type = this.types[i];
                    const editable = this.editable[i];
                    const hide = this.hide[i];


                    if (type === 'checkbox') {
                        const input = document.createElement('input');
                        input.type = 'checkbox';
                        input.checked = row[key] === 1 || row[key] === "1";
                        input.addEventListener('change', (e) => {
                            this.changeRow(e); // Только если изменилось
                        });
                        td.appendChild(input);

                    } else {
                        td.textContent = row[key] || '';
                        /*      td.contentEditable = true;
                              td.addEventListener('blur', (event) => this.changeRow(event)); */
                        td.addEventListener('focus', (e) => {
                            td.dataset.oldValue = td.textContent.trim();
                        });
                        td.addEventListener('blur', (e) => {
                            const oldValue = td.dataset.oldValue || '';
                            const newValue = td.textContent.trim();
                            if (newValue !== oldValue) {
                                this.changeRow(e); // Только если изменилось
                            }
                        });

                    }


                    td.style.display = hide;
                    td.contentEditable = editable;
                    td.classList.add(key);
                    td.tabIndex = 0;

                    tr.appendChild(td);
                });

                tbody.appendChild(tr);
            });
        }
        table.appendChild(tbody);
        scrollContainer.appendChild(table);
        tableWrapper.appendChild(scrollContainer);

        const navigator = this.createRecordNavigator();
        tableWrapper.appendChild(navigator);

        /*        const saveBtn = document.createElement('button');
                saveBtn.textContent = "Պահպանել փոփոխուփյունները";
                saveBtn.className = "save-button";
                saveBtn.addEventListener('click', () => this.getChangedRowsData());
        
                tableWrapper.appendChild(saveBtn); 
        */

        this.container.appendChild(tableWrapper);
        this.focusRow(0);
        this.addKeyboardNavigation();

    }

    getData() {
        const result = [];
        const rows = this.container.querySelectorAll('tbody tr');

        rows.forEach(row => {
            const cells = row.querySelectorAll('td');
            const rowData = {};

            for (let i = 1; i <= this.keys.length; i++) {
                const key = this.keys[i - 1];
                const type = this.types[i - 1];
                const cell = cells[i];

                if (type === 'checkbox') {
                    const input = cell.querySelector('input');
                    rowData[key] = input?.checked || false;
                } else {
                    rowData[key] = cell.textContent.trim();
                }
            }

            result.push(rowData);
        });
        return result;
    }

    addKeyboardNavigation() {
        const rows = this.container.querySelectorAll("tbody tr");

        rows.forEach((tr, rowIndex) => {
            const cells = tr.querySelectorAll("td");

            cells.forEach((td, colIndex) => {
                if (colIndex === 0) return;

                // Делаем td focusable
                td.tabIndex = 0;

                td.addEventListener("keydown", (e) => {
                    let targetRow = rowIndex;
                    let targetCol = colIndex;

                    switch (e.key) {
                        case "ArrowDown":
                            e.preventDefault();
                            targetRow = rowIndex + 1;
                            break;
                        case "ArrowUp":
                            e.preventDefault();
                            targetRow = rowIndex - 1;
                            break;
                        case "Enter":
                        case "ArrowRight":
                            e.preventDefault();
                            targetCol = colIndex + 1;
                            break;
                        case "ArrowLeft":
                            e.preventDefault();
                            targetCol = colIndex - 1;
                            break;
                        default:
                            return;
                    }

                    const targetRowEl = rows[targetRow];
                    if (targetRowEl) {
                        const targetCell = targetRowEl.querySelectorAll("td")[targetCol];
                        if (targetCell) {
                            targetCell.focus();
                        }
                    }
                });
            });
        });
    }

    createRecordNavigator() {
        const nav = document.createElement('div');
        nav.className = 'record-navigator';

        const label = document.createElement('span');
        label.textContent = 'Տողը:';
        nav.appendChild(label);

        const firstBtn = this.createNavButton('⏮', () => this.focusRow(0));
        const prevBtn = this.createNavButton('◀', () => this.focusRow(this.currentRow - 1));
        const nextBtn = this.createNavButton('▶', () => this.focusRow(this.currentRow + 1));
        const lastBtn = this.createNavButton('⏭', () => this.focusRow(this.data.length - 1));
        //const addBtn = this.createNavButton('✳', () => this.addRow({}));
        const addBtn = this.createNavButton('✳', () => this.addRow());

        this.recordInput = document.createElement('input');
        this.recordInput.type = 'number';
        this.recordInput.min = 1;
        this.recordInput.value = 1;
        this.recordInput.style.width = '50px';

        this.recordInput.addEventListener('change', () => {
            const index = parseInt(this.recordInput.value, 10) - 1;
            this.focusRow(index);
        });

        const of = document.createElement('span');
        of.className = "count_rows";
        of.textContent = ` / ${this.data.length}`;

        nav.appendChild(firstBtn);
        nav.appendChild(prevBtn);
        nav.appendChild(this.recordInput);
        nav.appendChild(nextBtn);
        nav.appendChild(lastBtn);
        nav.appendChild(addBtn);
        nav.appendChild(of);

        this.currentRow = 0;

        return nav;
    }
    createNavButton(label, onClick) {
        const btn = document.createElement('button');
        btn.textContent = label;
        btn.className = 'nav-btn';
        btn.addEventListener('click', onClick);
        return btn;
    }
    focusRow(index) {
        const rows = this.container.querySelectorAll('tbody tr');
        if (index < 0 || index >= rows.length) return;

        // հանել նշածները
        rows.forEach(row => row.classList.remove('active-row'));

        const row = rows[index];
        if (row) {
            row.classList.add('active-row');
            row.scrollIntoView({ behavior: "smooth", block: "center" });

            const editable = row.querySelector('td[contenteditable], td input[type="checkbox"]');
            if (editable) editable.focus();

            this.currentRow = index;
            this.recordInput.value = index + 1;
        }
    }

    checkRow(event) {
        const button = event.currentTarget;
        const rowElement = button.closest('tr');

        //նշել ընթացիկ տողը
        if (rowElement) {
            if (rowElement.classList.contains('active-row')) {
                rowElement.classList.remove('active-row');
            } else {
                rowElement.classList.add('active-row');
            }
            //console.log("Clicked row:", rowElement);
        }
    }
    changeRow(event) {
        const button = event.currentTarget;
        const rowElement = button.closest('tr');

        if (rowElement) {
            rowElement.classList.add('change-row');
            console.log("change row:", rowElement);
        }
    }

    addRow() {
        const emptyRow = {};
        this.keys.forEach((key, i) => {
            const type = this.types[i];
            if (type === 'checkbox') {
                emptyRow[key] = false;
            } else if (type == 'number') {
                emptyRow[key] = "0";
            } else {
                emptyRow[key] = "";
            }
        });

        this.data.push(emptyRow);
        // this.render();

        //գնալ նոր տող
        //this.focusRow(this.data.length - 1);

        // գտնում ենք tbody-ին որի մեջ ավելացնեում ենք տողը
        const tbody = this.container.querySelector('tbody');
        const index = this.data.length - 1;

        const tr = document.createElement('tr');

        // --- NN տողի համարը ---
        const tdNN = document.createElement('td');
        tdNN.className = "nn";
        const bt = document.createElement('input');
        bt.type = "button";
        bt.value = index + 1;
        bt.addEventListener('click', (event) => this.checkRow(event));
        tdNN.appendChild(bt);
        tr.appendChild(tdNN);

        // --- մնացած սյուները ---
        this.keys.forEach((key, i) => {
            const td = document.createElement('td');
            const type = this.types[i];
            const editable = this.editable[i];
            const hide = this.hide[i];

            if (type === 'checkbox') {
                const input = document.createElement('input');
                input.type = 'checkbox';
                input.checked = false;
                td.appendChild(input);
            } else {
                if (type === 'number') {
                    td.textContent = 0;
                } else {
                    td.textContent = '';
                }
                td.addEventListener('focus', (e) => {
                    td.dataset.oldValue = td.textContent.trim();
                });
                td.addEventListener('blur', (e) => {
                    const oldValue = td.dataset.oldValue || '';
                    const newValue = td.textContent.trim();
                    if (newValue !== oldValue) this.changeRow(e);
                });
            }

            td.style.display = hide;
            td.contentEditable = editable;
            td.classList.add(key);
            td.tabIndex = 0;

            tr.appendChild(td);
        });

        tbody.appendChild(tr);

        // Оավելացնում ենք տողերի քանակը
        const countLabel = this.container.querySelector(".count_rows");
        if (countLabel) countLabel.textContent = ` / ${this.data.length}`;

        // ֆոկուսը նոր տողի վրա
        this.focusRow(index);

    }

    /*    getChangedRowsData() {
            const changedRows = document.querySelectorAll('tr.change-row');
            const result = [];
    
            changedRows.forEach(row => {
                const rowData = {};
    
                row.querySelectorAll('td[class]').forEach(td => {
                    const key = td.className.trim();
                    const value = td.textContent.trim();
                    rowData[key] = value;
                });
    
                result.push(rowData);
            });
            console.log(JSON.stringify(result, null, 2));
            return result;
        }
    */

    /*showAddForm() {
        if (this.addFormElement) {
            this.addFormElement.remove();
        }

        const form = document.createElement('form');
        form.className = "add-form";

        this.keys.forEach((key, i) => {
            const input = document.createElement('input');
            input.type = 'text';
            input.name = key;
            input.placeholder = this.columns[i];
            input.className = "add-input";
            form.appendChild(input);
        });

        const submitBtn = document.createElement('button');
        submitBtn.type = 'submit';
        submitBtn.textContent = "Ավելացնել";
        submitBtn.className = "submit-button";

        form.appendChild(submitBtn);

        form.addEventListener('submit', (e) => {
            e.preventDefault();

            const newRow = {};
            this.keys.forEach(key => {
                const value = form.elements[key].value;
                newRow[key] = value;
            });

            this.data.push(newRow);
            this.render(); // перерисовываем таблицу
        });

        this.addFormElement = form;
        this.container.appendChild(form);
    }*/

}