function openCity(evt, cityName) {
    // Declare all variables
    var i, tabcontent, tablinks;

    // Get all elements with class="tabcontent" and hide them
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }

    // Get all elements with class="tablinks" and remove the class "active"
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }

    // Show the current tab, and add an "active" class to the button that opened the tab
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
};
function suppl_data() {

    const contdiv = document.getElementById("suppl_data");
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#suppl_data",
                [false, true, true, true],
                ['', '', '', ''],
                ["number", "text", "text", "number"],
                [{ idsupplier: "Կոդ" }, { supplier: "Մատակարար" }, { phone: "Հեռախոս" }, { partq0: "Պարտք0" }],
                result
            );

        }
    };

    xhttp.open("GET", "suppl_data.php?", true);
    xhttp.send();
}
function expcategories_data() {
    const contdiv = document.getElementById("expcategories_data");
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#expcategories_data",
                [false,true, true, true],
                ['none','', '', ''],
                ["number", "text", "text", "checkbox"],
                [{ id: "id" },{ idexpcategory: "Կոդ" }, { category: "Կատեգորիա" }, { exp: "Ծախս" }],
                result
            );
        }
    };

    xhttp.open("GET", "expcategories_data.php?", true);
    xhttp.send();
}
function ChangedRowsData(i) {
    const changedRows = document.querySelectorAll('tr.change-row');
    const result = [];

    changedRows.forEach(row => {
        const rowData = {};

        row.querySelectorAll('td[class]').forEach(td => {
            const key = td.className.trim();

            /*    const value = td.textContent.trim();
                rowData[key] = value;*/
            // Проверяем, является ли содержимое ячейки чекбоксом
            const input = td.querySelector('input[type="checkbox"]');
            if (input) {
                // Если это чекбокс, то берем его состояние
                rowData[key] = input.checked ? 1 : 0;  // 1 если выбран, 0 если не выбран
            } else {
                // Для обычных ячеек берем текстовое содержимое
                const value = td.textContent.trim();
                rowData[key] = value;
            }
        });

        result.push(rowData);
        row.classList.remove('change-row');
    });
    const data = JSON.stringify(result);
    console.log(data);
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            //const result = JSON.parse(xhttp.responseText);
            alert(xhttp.responseText);
        }
    }
    if (i == 1) {
        xhttp.open("GET", "suppl_changedata.php?changedata=" + data, true);
    } else if (i == 2) {
        xhttp.open("GET", "exp_changedata.php?changedata=" + data, true);
    }
    xhttp.send();

    //console.log(JSON.stringify(result, null, 2));
    //console.log(result);
}
function loadExcelToJSONTable(filePath, tableContainerId) {
    fetch(filePath)
        .then(res => res.arrayBuffer())
        .then(arrayBuffer => {
            const workbook = XLSX.read(arrayBuffer, { type: 'array' });
            const firstSheet = workbook.SheetNames[0];
            const worksheet = workbook.Sheets[firstSheet];

            // դարձնում ենք JSON օբյեկտներ մասիվ
            // header:1 → սյունակների անվանումներ, հետո արդեն մասիվը
            const jsonData = XLSX.utils.sheet_to_json(worksheet, { defval: "", raw: false });

            const newtable = new Table(
                tableContainerId,
                [false, false],             // editable
                ['', ''],                 // hide
                ["text", "text"],         // types
                Object.keys(jsonData[0]).map(k => ({ [k]: k })), // սյունակների գլխագիրը
                jsonData                   // JSON 
            );
        })
        .catch(err => {
            document.getElementById(tableContainerId.replace('#', '')).innerHTML =
                `<p style="color:red;">Ошибка загрузки Excel: ${err.message}</p>`;
        });
}

function applyFilters2() {
    const inputSearch = document.getElementById('searchATK');
    const inputcategory = document.getElementById('searchATKcategory');
    const table = document.querySelector("#atktable table");
    const rows = table?.getElementsByTagName('tbody')[0]?.getElementsByTagName('tr') || [];

    const searchText = inputSearch.value.toLowerCase().trim();
    const categoryText = inputcategory.value.toLowerCase().trim();

    savedSearchText = searchText;
    savedcategoryText = categoryText;

    let scrolled = false;

    for (let row of rows) {
        const ATK = row.cells[1].textContent.trim().toLowerCase();  // Անվանում
        const suppl = row.cells[2].textContent.trim().toLowerCase();   // Մատակարար

        const matchSearch = !searchText || ATK.includes(searchText);
        const matchcategory = !categoryText || suppl.includes(categoryText);// suppl === categoryText;

        row.style.display = (matchSearch && matchcategory) ? '' : 'none';
    }

}