async function find_kod() {
    const kodInput = document.getElementById("kod");
    const kod = kodInput.value.trim();
    const tbody = document.querySelector('#vajarq tbody');
    const active = document.querySelector('#vajarq tbody .active-row');
    const closeVajarq = document.getElementById("close_vajarq");
    const moneyInput = document.getElementById("money");
    const changeInput = document.getElementById("change");

    // Если чек закрыт — очищаем и выходим
    if (closeVajarq.style.display === "block") {
        tbody.innerHTML = "";
        closeVajarq.style.display = "none";
        changeInput.value = 0;
        moneyInput.value = 0;
        return;
    }

    // --- Оплата ---
    if (kod.startsWith("+")) {
        const sum = Number(kod.slice(1));
        if (isNaN(sum)) return alert("Неверная сумма.");
        moneyInput.value = sum;
        changeInput.value = sum - Number(document.getElementById("gumar").value);
        save_vajarq();
        kodInput.value = "";
        closeVajarq.style.display = "block";
        get_total_vajarq();
        return;
    }

    // --- Изменение цены ---
    if ((kod[0] === "g" || kod[0] === "G") && !isNaN(Number(kod.slice(1)))) {
        if (!active) return alert("Նշեք ապրանքը նախքան այս գործողությունը։");
        const cells = active.querySelectorAll('td');
        cells[7].textContent = kod.slice(1);
        calc_zexj();
        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    // --- Короткие коды: скидка или количество ---
    if (kod.length < 4) {
        if (!active) return alert("Նշեք ապրանքը նախքան այս գործողությունը։");
        const cells = active.querySelectorAll('td');

        // Скидка
        if ((kod[0] === "z" || kod[0] === "Z") && !isNaN(Number(kod.slice(1)))) {
            cells[6].textContent = kod.slice(1);
            calc_zexj();
        } 
        // Количество
        else if (!isNaN(Number(kod))) {
            const p1 = Number(cells[7].textContent.trim());
            cells[4].textContent = kod;
            cells[8].textContent = (kod * p1).toFixed(2);
        } 
        else {
            alert("Լրացրեք ճիշտ տվյալներ։");
        }

        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    // --- Коды товаров (>=4 цифр) ---
    if (!isNaN(Number(kod)) && kod.length >= 4) {
        try {
            const response = await fetch(`get_order_apranq.php?idapranq=${encodeURIComponent(kod)}`);
            if (!response.ok) throw new Error("Սերվերի սխալ։");
            
            const result = await response.json();
            if (!result || result.length === 0) {
                alert("այդպիսի կոդով ապրանք չկա բազայում");
                return;
            }

            // Удаляем предыдущие active-row
            document.querySelectorAll('#vajarq .active-row')
                .forEach(row => row.classList.remove('active-row'));

            // Добавляем новую строку
            const tr = document.createElement('tr');
            tr.classList.add('active-row');
            const tr_data = [
                "1", result[0].ida, result[0].idapranq,
                result[0].apranq, 1, result[0].p1, 0,
                result[0].p1, result[0].p1
            ];

            tr_data.forEach((value, index) => {
                const td = document.createElement('td');
                td.textContent = value;
                if (index === 1) td.style.display = "none";
                else td.tabIndex = 0;
                tr.appendChild(td);
            });

            tbody.appendChild(tr);
            tr.scrollIntoView({ behavior: 'smooth', block: 'center' });

        } catch (error) {
            console.error(error);
            alert("Սխալ՝ ապրանքի բեռնումը չհաջողվեց։");
        }

        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    // --- Если ничего не подошло ---
    alert("Լրացրեք ճիշտ տվյալներ։");
    kodInput.value = "";
    get_total_vajarq();
}
 