let nn = 1;
async function find_kod() {                //այս տարբերակում օգտագործում ենք fetch() այլ ոչ թե XMLHttpRequest
    const kodInput = document.getElementById("kod");
    const kod = kodInput.value.trim();
    const tbody = document.querySelector('#vajarq tbody');
    const active = document.querySelector('#vajarq tbody .active-row');
    const closeVajarq = document.getElementById("close_vajarq");
    const moneyInput = document.getElementById("money");
    const changeInput = document.getElementById("change");

    // Եթե կտրոնը փակ է՝ մաքրում ենք ու դուրս ենք գալիս
    if (closeVajarq.style.display === "block") {
        //tbody.innerHTML = "";
        //closeVajarq.style.display = "none";
        //changeInput.value = 0;
        //moneyInput.value = 0;
        alert('Փակ կտրոն');
        return;
    }


    // ---փնտրում ---
    if (kod.startsWith("*")) {
        const k1 = kod.slice(1);
        if (k1.startsWith("*")) {
            const k2 = k1.slice(1);
            if (k2.startsWith("*")) {
                k3 = k2.slice(1);
                //"***"փնտրում ըստ գնի
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const result = JSON.parse(xhttp.responseText);
                        if (result == "0") {
                            alert("Այդպիսի ապրանք չկա։");
                            return;
                        }
                        const contdiv = document.getElementById("findapr_data2");
                        console.log(result);
                        contdiv.innerHTML = '';
                        // ստեղծում է աղյուսակը
                        const newtable = new Table(
                            "#findapr_data2",
                            [false, false, true, false, false],
                            ['', '', '', ''],
                            ["number", "text", "text", "number"],
                            [{ ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { p1: "Գին" }],
                            result
                        );
                        document.getElementById('findapr2').style.display = 'block';
                        //նշում ենք առաջին տողը
                        const firstRow = document.querySelector('#findapr_data2 table tr');
                        if (firstRow) {
                            firstRow.classList.add('active-row');
                        }
                    }
                }
                xhttp.open("GET", "get_order_apranq.php?gin=" + k3, true);
                xhttp.send();
            } else {
                //"**"փնտրում ըստ վերջին նիշերով
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const result = JSON.parse(xhttp.responseText);
                        if (result == "0") {
                            alert("Այդպիսի ապրանք չկա։");
                            return;
                        }
                        const contdiv = document.getElementById("findapr_data2");
                        contdiv.innerHTML = '';
                        // ստեղծում է աղյուսակը
                        const newtable = new Table(
                            "#findapr_data2",
                            [false, false, true, false, false],
                            ['', '', '', ''],
                            ["number", "text", "text", "number"],
                            [{ ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { p1: "Գին" }],
                            result
                        );
                        document.getElementById('findapr2').style.display = 'block';
                        //նշում ենք առաջին տողը
                        const firstRow = document.querySelector('#findapr_data2 table tr');
                        if (firstRow) {
                            firstRow.classList.add('active-row');
                        }
                    }
                }
                xhttp.open("GET", "get_order_apranq.php?lastdigi=" + k2, true);
                xhttp.send();
            }
        } else {
            //"*"փնտրում ըստ անունի
            //const apr = document.getElementById("apranq").value;

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const result = JSON.parse(xhttp.responseText);
                    if (result == "0") {
                        alert("Այդպիսի ապրանք չկա։");
                        return;
                    }
                    const contdiv = document.getElementById("findapr_data2");
                    contdiv.innerHTML = '';
                    // ստեղծում է աղյուսակը
                    const newtable = new Table(
                        "#findapr_data2",
                        [false, false, true, false, false],
                        ['', '', '', ''],
                        ["number", "text", "text", "number"],
                        [{ ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { p1: "Գին" }],
                        result
                    );
                    document.getElementById('findapr2').style.display = 'block';
                    //նշում ենք առաջին տողը
                    const firstRow = document.querySelector('#findapr_data2 table tr');
                    if (firstRow) {
                        firstRow.classList.add('active-row');
                    }
                }
            }
            xhttp.open("GET", "get_order_apranq.php?apranq=" + k1, true);
            xhttp.send();
        }
        return;
    }

    // --- Վճարում ---
    if (kod.startsWith("+")) {
        var sum = Number(kod.slice(1));
        if (sum == 0) {
            sum = Number(document.getElementById("gumar").value);
        }
        moneyInput.value = sum;
        changeInput.value = sum - Number(document.getElementById("gumar").value);
        save_vajarq();
        kodInput.value = "";
        closeVajarq.style.display = "block";
        get_total_vajarq();
        return;
    }

    // --- Գնի փոփոխություն ---
    if ((kod[0] === "g" || kod[0] === "G") && !isNaN(Number(kod.slice(1)))) {
        const cells = active.querySelectorAll('td');
        cells[7].textContent = kod.slice(1);
        calc_zexj();
        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    const raw = kod.trim();
    // -------------zexj -------------------
    if (/^[zZ]\d+(\.\d+)?$/.test(raw)) {
        const cells = active.querySelectorAll('td');
        const discount = Number(raw.slice(1));
        cells[6].textContent = discount;
        calc_zexj();
        kodInput.value = "";
        return;
    }

    // kod-@ darcnenq tiv ev stugenq -1000 <= kod <= 1000
    //----- qanak . ev aranc ------------------------    
    const num = Number(raw);
    if (num >= -1000 && num <= 1000) {
        // այստեղ num արդեն թիվ է
        const cells = active.querySelectorAll('td');
        const p1 = Number(cells[7].textContent.trim());
        cells[4].textContent = num;
        cells[8].textContent = (num * p1).toFixed(2);

        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    // --- ապրանքի կոդեր (>=4 նիշ) ---
    if (!isNaN(Number(kod)) && kod.length >= 4) {
        try {
            const response = await fetch(`get_order_apranq.php?idapranq=${encodeURIComponent(kod)}`);
            if (!response.ok) throw new Error("Սերվերի սխալ։");

            const result = await response.json();
            if (!result || result == "0") {
                alert("այդպիսի կոդով ապրանք չկա բազայում");
                return;
            }

            // ջնջում ենք նախորդ active-row
            document.querySelectorAll('#vajarq .active-row')
                .forEach(row => row.classList.remove('active-row'));

            // ավելացնում ենք նոր տող
            const tr = document.createElement('tr');
            tr.classList.add('active-row');
            const tr_data = [
                nn, result[0].ida, result[0].idapranq,
                result[0].apranq, 1, result[0].p1, 0,
                result[0].p1, result[0].p1
            ];

            tr_data.forEach((value, index) => {
                const td = document.createElement('td');
                td.textContent = value;
                if (index === 1) td.style.display = "none";
                else td.tabIndex = 0;
                tr.appendChild(td);
            });

            tbody.appendChild(tr);
            tr.scrollIntoView({ behavior: 'smooth', block: 'center' });
            nn = nn + 1;
        } catch (error) {
            console.error(error);
            alert("Սխալ՝ ապրանքի բեռնումը չհաջողվեց։");
        }

        kodInput.value = "";
        get_total_vajarq();
        return;
    }

    // --- եթե ոչ մի տարբերակը չէ ---
    alert("Լրացրեք ճիշտ տվյալներ։");
    kodInput.value = "";
    get_total_vajarq();
}

//-----------------
function save_vajarq() {
    var gumar = document.getElementById("gumar").value;
    var money = document.getElementById("money").value;
    const terminal = 0;
    const rows = document.querySelectorAll('#vajarq tbody tr');
    const jsonData = [];

    rows.forEach(row => {
        const cells = row.querySelectorAll('td');
        const qanValue = cells[4]?.textContent.trim();
        const qanak = qanValue ? parseFloat(qanValue.replace(',', '.')) : NaN;
        const rowData = {
            ida: cells[1]?.textContent.trim() || "",
            qan: qanak,
            p2: cells[5]?.textContent.trim() || "",
            z: cells[6]?.textContent.trim() || "",
            p1: cells[7]?.textContent.trim() || "",
        };
        jsonData.push(rowData);
    });
    console.log(jsonData);
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById('ktron_num').innerHTML = "";
            document.getElementById('ktron_num').innerHTML = xhttp.responseText;
        }
    }
    xhttp.open("POST", "new_vajarq.php", true);
    xhttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    xhttp.send("idkassa=1&idoperator=1&gumar=" + encodeURIComponent(gumar) +
        "&money=" + encodeURIComponent(money) +
        "&terminal=" + terminal +
        "&jsondata=" + encodeURIComponent(JSON.stringify(jsonData)));
}
function get_total_vajarq() {
    let total_vaj = 0;
    const rows = document.querySelectorAll('#vajarq tbody tr');
    if (rows.length > 0) {
        for (let i = 0; i < rows.length; i++) {
            const cells = rows[i].getElementsByTagName('td');
            const count = parseFloat(cells[4].textContent.trim());
            const p1 = parseFloat(cells[7].textContent.trim());
            total_vaj += count * p1;
        }
    }
    document.getElementById("gumar").value = (total_vaj/10).toFixed(0)*10;
}

function calc_zexj() {
    const active = document.querySelector('#vajarq tbody .active-row');
    const cells = active.querySelectorAll('td');
    const kod = document.getElementById("kod").value;
    if (kod[0] == "z" || kod[0] == "z") {
        cells[7].textContent = (cells[5].textContent.trim() * (1 - cells[6].textContent.trim() / 100)).toFixed(2);
    } else if (kod[0] == "g" || kod[0] == "G") {
        cells[6].textContent = (100 - cells[7].textContent.trim() * 100 / cells[5].textContent.trim()).toFixed(2);
    }
    cells[8].textContent = (cells[4].textContent.trim() * cells[7].textContent.trim()).toFixed(2);
    get_total_vajarq();
}
function choose_apr() {
    const row = document.querySelectorAll('#findapr_data2 tbody .active-row');  //վերցնում է հենց findapr_data-ի աղյուսակի նշված տողերը
    if (row.length == 1) {
        const cells = row[0].getElementsByTagName('td');
        document.getElementById("kod").value = cells[2].textContent.trim();
        find_kod();
        row[0].classList.remove('active-row');
        document.getElementById("kod").focus();
    } else {
        alert("Ընտրեք միայն մեկ ապրանք");
    }
}

/*function chose_ktron() {          //texapoxel em index.php
    //active = document.querySelector('#ktron tbody .active-row');
    //const cells = active.querySelectorAll('td');
    //const idv = cells[1].textContent.trim();
    const idv=document.getElementById('idktron').value;

    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);
            if (result == "0") {
                alert("Այսօր դեռ վաճառք չկա");
                return;
            }
            const contdiv = document.getElementById("ktron_data");
            //    console.log(result);
            //contdiv.innerHTML = '';
            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#ktron_data",
                [false,false,  false, false, false, false],
                ['','','', '', '', ''],
                ["number","text", "number", "number", "number", "number"],
                [{ idapranq: "IDApranq" },{ apranq: "Apranq" }, { qan: "Քանակ" }, { p2: "Գին" }, { z: "Զեղչ" }, { p1: "Գին" }],
                result
            );
           // document.getElementById('history_vajarq').style.display = 'block';
            //նշում ենք առաջին տողը
            //const firstRow = document.querySelector('#ktron_data table tr');
            //if (firstRow) {
            //    firstRow.classList.add('active-row');
            //}
        }
    }
    xhttp.open("GET", "get_vajarq.php?idvajarq=" + idv, true);
    xhttp.send();

}*/

// տեղաշարժ աղյուսակի մեջ սլաքներով
document.addEventListener('keydown', function (event) {
    let rows = [];
    let active = null;

    if (document.getElementById("findapr2").style.display === "block") {
        rows = Array.from(document.querySelectorAll('#findapr_data2 tbody tr'));
        active = document.querySelector('#findapr_data2 tbody .active-row');
    } else if (document.getElementById('history_vajarq').style.display === 'block') {
        rows = Array.from(document.querySelectorAll('#ktron tbody tr'));
        active = document.querySelector('#ktron tbody .active-row');
    } else {
        rows = Array.from(document.querySelectorAll('#vajarq tbody tr'));
        active = document.querySelector('#vajarq tbody .active-row');
    }

    const currentIndex = rows.indexOf(active);

    if (event.key === 'ArrowUp') {       // index.php
        if (currentIndex > 0) {
            active.classList.remove('active-row');
            rows[currentIndex - 1].classList.add('active-row');
            if (document.getElementById('history_vajarq').style.display === 'block') {
                const kt = document.querySelector('#ktron tbody .active-row');
                const c = kt.querySelectorAll('td');
                document.getElementById('idktron').value = c[1].textContent.trim();
                chose_ktron();
            }
        }
    } else if (event.key === 'ArrowDown') {
        if (currentIndex < rows.length - 1) {
            active.classList.remove('active-row');
            rows[currentIndex + 1].classList.add('active-row');
            if (document.getElementById('history_vajarq').style.display === 'block') {
                const kt = document.querySelector('#ktron tbody .active-row');
                const c = kt.querySelectorAll('td');
                document.getElementById('idktron').value = c[1].textContent.trim();
                chose_ktron();
            }
        }
    } else if (event.key === 'F5') {
        window.print();
        //api
        //QZ Tray 
        //node.js
    } else if (event.key === 'F12') {
        event.preventDefault(); // попытка отменить стандартное действие (не всегда сработает)
        const tbody = document.querySelector('#vajarq tbody');
        tbody.innerHTML = "";
        document.getElementById("close_vajarq").style.display = "none";
        document.getElementById("gumar").value = 0;
        document.getElementById("change").value = 0;
        document.getElementById("money").value = 0;
        nn = 1;
    } else if (event.key === 'F7') {
        event.preventDefault(); // попытка отменить стандартное действие (не всегда сработает)
        fetchVajarqData("history_vajarq_sub");  /// index.php
    }

    if (document.getElementById("findapr2").style.display === "block" && event.key === 'Enter') {
        choose_apr();
        document.getElementById('findapr2').style.display = 'none';
    }

});